	function [h, Err, Dev] = REMEZ_EX(Nfilt, Neg, Nfcns, Ngrid, Grid, Iext, Des, Wt)
	
	% 	Function REMEZ_EX implements the Remez exchange algorithm for the weigthed 
	%	Chebyshev approximation of a continous function with a sum of cosines.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
		
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	LW, 2019-03-04
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi
	
	
	Nodd = mod(Nfilt, 2);
	Nm1 = Nfcns-1; Tpi = 2*pi; goto = 1;
	while goto <= 43
		switch goto
		case 1
			Itrmax = 2500; 	% TS: Allow a maximum number of interations of 2500
			Devl = -1;
			Nzr = Nfcns+1;
			Nzz = Nfcns+2;
			Niter = 0; goto = 2;
		case 2
			Iext(Nzz) = Ngrid+1;
			Niter = Niter+1;
			if Niter > Itrmax, break; end
			X(1:Nzr) = cos(Tpi*Grid(Iext(1:Nzr)));
			Jet = fix((Nfcns-1)/15)+1;
			for j = 1:Nzr, Ad(j) = D(j, Nzr, Jet, X); end 
			Dnum = 0; Dden = 0;
			Kr = 1;
			for j = 1:Nzr
				Lr = Iext(j);
				Dnum = Dnum + Ad(j).*Des(Lr);
				Dden = Dden + Kr*Ad(j)./Wt(Lr);
				Kr = -Kr;
			end
			Dev = Dnum/Dden;
			Nu = 1;
			if Dev > 0, Nu = -1; end
			Dev = -Nu*Dev;
			% disp([' Dev =  ' num2str(Dev)])
			Kr = Nu;
			for j = 1:Nzr
				Lr = Iext(j);
				Y(j) = Des(Lr) + Kr*Dev/Wt(Lr);
				Kr = -Kr;
			end 
			if Dev < Devl 
				% Routine OUCH
				disp(' ****** Failure to converge ******** ')
				disp(' 1 Probable cause is machine rounding error.')
				disp(' 2 Impulse response may be correct.')
				disp(' 3 Check with a frequency response analysis.')
				goto = 50;
			end
			Devl = Dev;
			Jchange = 0;
			K1 = Iext(1);
			Knz = Iext(Nzr);
			Klow = 0;
			Nut = -Nu;
			Jr = 1; goto = 5;
		case 5
			% ===============================================
			% Seach for the external frequencies of the best approximation
			if Jr == Nzz, Ynz = Comp; end
			if Jr >= Nzz, 
				if Jr > Nzz,  
					if Luck > 9, 
						Kn = Iext(Nzz);
						for Jr = 1:Nfcns, Iext(Jr) = Iext(Jr+1); end 
						Iext(Nzr) = Kn; goto = 2;
					else 
						if Comp > Y1, Y1 = Comp; end
						K1 = Iext(Nzz); goto = 36;
					end
				else 
					if K1 > Iext(1), K1 = Iext(1); end
					if Knz < Iext(Nzr), Knz = Iext(Nzr); end
					Nut1 = Nut; Nut = -Nu;
					Lr = 0; Kupr = K1;
					Comp = Ynz*1.0001;
					Luck = 1; goto = 30;
				end
			else 
				goto = 6;
			end
		case 6
			Kupr = Iext(Jr+1);
			Lr = Iext(Jr)+1;
			Nut = -Nut;
			if Jr == 2, Y1 = Comp; end
			Comp = Dev;
			if Lr >= Kupr, 
				goto = 13; 
			else 
				Geex = Gee(Lr, Nzr, Ad, Grid, X, Y);
				Err = (Geex - Des(Lr))*Wt(Lr);
				Dtemp = Nut*Err - Comp;
				if Dtemp <= 0, 
					goto = 13; 
				else 
					Comp = Nut*Err; goto = 9;
				end
			end
		case 9
			Lr = Lr+1;
			if Lr >= Kupr, 
				goto = 12; 
			else 
				Geex = Gee(Lr, Nzr, Ad, Grid, X, Y);
				Err = (Geex - Des(Lr))*Wt(Lr);
				Dtemp = Nut*Err - Comp;
				if Dtemp <= 0, 
					goto = 12; 
				else 
					Comp = Nut*Err; goto = 9;
				end
			end
		case 12
			Iext(Jr) = Lr-1; Jr = Jr+1; Klow = Lr-1;
			Jchange = Jchange+1; goto = 5;
		case 13
			Lr = Lr-1; goto = 14;
		case 14
			Lr = Lr-1;
			if Lr <= Klow, 
				Lr = Iext(Jr)+1;
				if Jchange > 0, goto = 12; else goto = 24; end
			else 
				Geex = Gee(Lr, Nzr, Ad, Grid, X, Y);
				Err = (Geex - Des(Lr))*Wt(Lr);
				Dtemp = Nut*Err - Comp;
				if Dtemp > 0, 
					Comp = Nut*Err; goto = 19;
				else 
					if Jchange <= 0, goto = 14; else goto = 27; end
				end
			end
		case 19
			Lr = Lr-1;
			if Lr <= Klow, 
				goto = 22; 
			else 
				Geex = Gee(Lr, Nzr, Ad, Grid, X, Y);
				Err = (Geex - Des(Lr))*Wt(Lr);
				Dtemp = Nut*Err - Comp;
				if Dtemp <= 0, 
					goto = 22;
				else 
					Comp = Nut*Err; goto = 19;
				end
			end
		case 22
			Klow = Iext(Jr); Iext(Jr) = Lr+1; Jr = Jr+1;
			Jchange = Jchange+1; goto = 5;
		case 24 
			Lr = Lr+1;
			if Lr >= Kupr, 
				goto = 27; 
			else 
				Geex = Gee(Lr, Nzr, Ad, Grid, X, Y);
				Err = (Geex - Des(Lr))*Wt(Lr);
				Dtemp = Nut*Err - Comp;
				if Dtemp <= 0, 
					goto = 24; 
				else 
					Comp = Nut*Err; goto = 9; 
				end 
			end
		case 27
			Klow = Iext(Jr);
			Jr = Jr+1; goto = 5;
		case 30
			Lr = Lr+1;
			if Lr >= Kupr, 
				Luck = 6; goto = 36;
			else 
				Geex = Gee(Lr, Nzr, Ad, Grid, X, Y);
				Err = (Geex - Des(Lr))*Wt(Lr);
				Dtemp = Nut*Err - Comp;
				if Dtemp <= 0, 
					goto = 30; 
				else 
					Comp = Nut*Err;
					Jr = Nzz; goto = 9; 
				end
			end
		case 36
			Lr = Ngrid+1; Klow = Knz; Nut = -Nut1;
			Comp = Y1*1.00001; goto = 37;
		case 37 
			Lr = Lr-1;
			if Lr <= Klow, 
				if Luck == 6, 
					if Jchange > 0, goto = 2; else goto = 50; end
				else 		
					for Jr = 1:Nfcns, Iext(Nzz-Jr) = Iext(Nzr-Jr); end 
					Iext(1) = K1; goto = 2;
				end
			else 
				Geex = Gee(Lr, Nzr, Ad, Grid, X, Y);
				Err = (Geex - Des(Lr))*Wt(Lr);
				Dtemp = Nut*Err - Comp;
				if Dtemp <= 0,
					goto = 37; 
				else 
					Jr = Nzz; Comp = Nut*Err;
					Luck = Luck+10; goto = 19;
				end
			end
		end 
	end
	% =======================================
	% Calculation of the coefficients of the best approximation
	% using the inverse Discrete Fourier Transform
	Nm1 = Nfcns-1;	Fsh = 0.000001;	Gtemp = Grid(1); X(Nzz) = -2;
	Cn = 2*Nfcns-1; Delfr = 1/Cn;
	Lr = 1; Kkk = 0;
	% if (Grid(1) < 0.01) & (Grid(Ngrid) > 0.49), Kkk = 1; end
	if (Grid(1) == 0) & (Grid(Ngrid) == 0.5), Kkk = 1; end
	if Nfcns <= 3, Kkk = 1; end
	if Kkk ~= 1
		Dtemp = cos(Tpi*Grid(1));	Dnum = cos(Tpi*Grid(Ngrid));
		Aa = 2/(Dtemp-Dnum);		Bb = -(Dtemp+Dnum)/(Dtemp-Dnum);
	end
	for Jr = 1:Nfcns
		Ft = (Jr-1)*Delfr;	Xt = cos(Tpi*Ft);
		if Kkk ~= 1, Xt = (Xt-Bb)/Aa; Ft = acos(Xt)/Tpi; end
		flag = 0;
		while flag == 0 
			Xe = X(Lr);  
			if Xt > Xe     
				flag = 1;
				if (Xt-Xe) < Fsh
					A(Jr) = Y(Lr);
				else
					Grid(1) = Ft;
					Geex = Gee(1, Nzr, Ad, Grid, X, Y);
					A(Jr) = Geex ;
				end
			else
				if (Xe-Xt) < Fsh
					A(Jr) = Y(Lr); flag = 1;
				else
					Lr = Lr+1;
				end
			end  
		end   
		if (Lr > 1), Lr = Lr-1; end       
	end
	Grid(1) = Gtemp;	Dden = Tpi/Cn;
	for Jr = 1:Nfcns
		Dtemp = 0;	Dnum = (Jr-1)*Dden;
		if Nm1 >= 1
			for Kr = 1:Nm1
				Dtemp = Dtemp + A(Kr+1)*cos(Dnum*Kr);
			end
		end
		Alpha(Jr) = 2*Dtemp+A(1);
	end 

	for Jr = 2:Nfcns, Alpha(Jr) = 2*Alpha(Jr)/Cn; end 
	Alpha(1) = Alpha(1)/Cn;
	if Kkk ~= 1
		P(1) = 2*Alpha(Nfcns)*Bb + Alpha(Nm1);
		P(2) = 2*Aa*Alpha(Nfcns); Q(1) = Alpha(Nfcns-2) - Alpha(Nfcns);
		for Jr = 2:Nm1
			if Jr >= Nm1
				Aa = 0.5*Aa; Bb = 0.5*Bb;
			end 
			P(Jr+1) = 0;
			A(1:Jr) = P(1:Jr); P(1:Jr) = 2*Bb*A(1:Jr);
			P(2) = P(2) + A(1)*2*Aa;
			Jm1 = Jr-1;
			for Kr = 1:Jm1
				P(Kr) = P(Kr) + Q(Kr) + Aa*A(Kr+1);
			end
			Jp1 = Jr+1;
			for Kr = 3:Jp1, P(Kr) = P(Kr) + Aa*A(Kr-1); end 
			if Jr ~= Nm1 
				for Kr = 1:Jr, Q(Kr) = -A(Kr); end 
				Q(1) = Q(1) + Alpha(Nfcns-1-Jr);
			end
		end 
		Alpha = P;
	end
	if Nfcns <= 3
		Alpha(Nfcns+1) = 0;		Alpha(Nfcns+2) = 0;
	end
	h = Impulse(Neg, Nodd, Nfcns, Alpha);
	return 
	% ===============================================
	function D = D(k, N, M, X)
	
	%	Function D to calculate the Lagrange interpolation coefficients
	D = 1; Q = X(k);
	for L = 1:M
		for j = L:M:N
			if (j ~= k), D = 2*D*(Q - X(j)); end
		end 
	end 
	D = 1/D;
	return
	% ===============================================
	function Gee = Gee(L, N, Ad, Grid, X, Y)
 
	%	Function Gee to evaluate the frequency response using the 
	%	Lagrange interpolation formula in the Barycentric form.
	Tpi = 2*pi;
	P = 0; D = 0;
	for j = 1:N
		C = cos(Tpi*Grid(L)) - X(j);
		C = Ad(j)/C;
		D = D + C;
		P = P + C*Y(j);
	end
	Gee = P/D;
	return 	
	% ===============================================
	function h = Impulse(Neg, Nodd, Nfcns, Alpha)
	
	%	 Calculate the impulse response
	Nm1 = Nfcns-1;
	Nz = Nfcns+1;
	if Neg == 1 
		if Nodd == 0
			h(1) = 0.25*Alpha(Nfcns);
			for j = 2:Nm1
				h(j) = 0.25*(Alpha(Nz-j) - Alpha(Nfcns+2-j));
			end 
			h(Nfcns) = 0.5*Alpha(1) - 0.25*Alpha(2);
		else
			h(1) = 0.25*Alpha(Nfcns);
			h(2) = 0.25*Alpha(Nm1);
			for j = 3:Nm1
				h(j) = 0.25*(Alpha(Nz-j) - Alpha(Nfcns+3-j));
			end 
			h(Nfcns) = 0.5*Alpha(1) - 0.25*Alpha(3);
			h(Nz) = 0;
		end
	else
		if Nodd == 0
			h(1) = 0.25*Alpha(Nfcns);
			for j = 2:Nm1
				h(j) = 0.25*(Alpha(Nz-j) + Alpha(Nfcns+2-j));
			end 
			h(Nfcns) = 0.5*Alpha(1) + 0.25*Alpha(2);
		else
			for j = 1:Nm1, h(j) = 0.5*Alpha(Nz-j); end
			h(Nfcns) = Alpha(1);
		end
	end
